package gov.va.med.mhv.mrp.service.converter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.mrp.common.dto.MyGoalTaskDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalsTaskActivitiesDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalsTaskExtensionsDTO;
import gov.va.med.mhv.mrp.data.model.MyGoalsTaskActivities;
import gov.va.med.mhv.mrp.data.model.MyGoalsTaskExtensions;
import gov.va.med.mhv.mrp.data.model.MyGoalsTasks;

@Component
public class MyGoalTaskDTOConverter implements Converter<MyGoalTaskDTO, MyGoalsTasks> {

	@Autowired
	private MyGoalsTaskActivitiesDTOConverter myGoalsTaskActivitiesDTOConverter;
	
	@Autowired
	private MyGoalsTaskExtensionsDTOConverter myGoalsTaskExtensionsDTOConverter;
	
	@Override
	public MyGoalsTasks convert(MyGoalTaskDTO dto) {
		MyGoalsTasks e = new MyGoalsTasks();
		
		e.setCompletedDate(dto.getCompletedDate());
		e.setCompletionType(dto.getCompletionType());
		e.setDescription(dto.getDescription());
		e.setEndDate(dto.getEndDate());
		e.setEndTime(dto.getEndTime());
		e.setTaskId(dto.getTaskId());
		e.setStartDate(dto.getStartDate());
		e.setStartTime(dto.getStartTime());
		e.setStatus(dto.getStatus());
		e.setTaskName(dto.getTaskName());
		e.setTaskRepetitionCycleType(dto.getTaskRepetitionCycleType());
		e.setTaskSequenceNumber(dto.getTaskSequenceNumber());
		e.setOplock(dto.getOplock());
		
		if (dto.getMyGoalsTaskActivities() != null) {
			for (MyGoalsTaskActivitiesDTO activityDTO : dto.getMyGoalsTaskActivities()) {
				MyGoalsTaskActivities activity = myGoalsTaskActivitiesDTOConverter.convert(activityDTO);
				e.addMyGoalsTaskActivity(activity);
			}
		}
		
		if (dto.getMyGoalsTaskExtensions() != null) {
			for (MyGoalsTaskExtensionsDTO taskExtDTO : dto.getMyGoalsTaskExtensions()) {
				MyGoalsTaskExtensions taskExt = myGoalsTaskExtensionsDTOConverter.convert(taskExtDTO);
				e.addMyGoalsTaskExtension(taskExt);
			}
		}
		
		return e;
	}

}
